% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_comp_plot.R
\name{compare_bootstrap}
\alias{compare_bootstrap}
\title{Compare Bootstrap Distributions}
\usage{
compare_bootstrap(
  exact_bootstrap_distribution,
  regular_bootstrap_distribution,
  title = "Comparison of Bootstrap Distributions"
)
}
\arguments{
\item{exact_bootstrap_distribution}{An named list returned from
exact_bootstrap() with components dens$x (the coordinates of the points where
the density is estimated) and y (the estimated density values), representing
the density estimate of the exact bootstrap sample statistic.}

\item{regular_bootstrap_distribution}{An named list returned from
reg_bootstrap() with components dens$x (the coordinates of the points where
the density is estimated) and y (the estimated density values), representing
the density estimate of the regular bootstrap sample statistic.}

\item{title}{Plot title}
}
\value{
A ggplot object showing the density estimates of the exact and regular
bootstrap sample statistics, with different colors used to distinguish between
the two.
}
\description{
This function generates a plot comparing the density estimates of the exact
and regular bootstrap distributions.
}
\examples{
set.seed(123)
data <- rnorm(5)
exact_bootstrap_result <- exact_bootstrap(data)
regular_bootstrap_result <- reg_bootstrap(data)
compare_bootstrap(exact_bootstrap_result,
                  regular_bootstrap_result)
}
