% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round2_fmt.R
\name{round2_fmt}
\alias{round2_fmt}
\alias{round2}
\alias{fmt}
\title{Rounding and Formatting Numbers}
\usage{
round2(x, digits = 0)

fmt(x, digits = 2L, zeros = digits < 4L, ...)
}
\arguments{
\item{x}{Numeric vector to be rounded or formatted.}

\item{digits}{Integer, number of decimal places. Default is 0 for \code{round2}, 2 for \code{fmt}.}

\item{zeros}{Logical, whether to keep trailing zeros. Default is TRUE if digits < 4 (\code{fmt} only).}

\item{...}{Additional arguments passed to \code{format()} (\code{fmt} only).}
}
\value{
\code{round2} returns a numeric vector rounded to the specified number of digits.
\code{fmt} returns a character vector with numbers formatted as strings with the requested number of decimal places.
}
\description{
These functions provide rounding and formatting similar to \code{exams::round2} and \code{exams::fmt}.
\code{round2} performs half-up rounding with a small offset to avoid rounding errors.
\code{fmt} formats numbers as character strings with a specified number of decimal places.
}
\seealso{
\code{\link[exams]{round2}}, \code{\link[exams]{fmt}} from the \code{exams} package.
}
\author{
Adapted from \code{exams} package by R. Schwabe et al.
}
\keyword{internal}
