% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{pack}
\alias{pack}
\title{Make Shiny Application to Executable File}
\usage{
pack(app_name = "myapp", electron_settings = list(), option = list())
}
\arguments{
\item{app_name}{Name of your application. Default will be "myapp".}

\item{electron_settings}{A list including package.json settings. Including product_name, app_version, app_description, author_name, author_email, repository_url}

\item{option}{A list containing option for packing. See option_description.md for details.}
}
\value{
Returns nothing. For generating new files.
}
\description{
This Function make your shiny app to an executable file
Go to your project directory(Including app.R), and run this function.
}
\examples{
if (interactive()) {
  # Needs at least 1 minute.
  pack(
    app_name = "myapp",
    electron_settings = list(
      c("product_name_template", "My Own Product Name"),
      c("app_description_template", "App Description"),
      c("author_name_template", "Author Name"),
      c("author_email_template", "Author E-mail"),
      c("repository_url_template", "Repository URL")
    ),
    option = list()
  )
}
}
\author{
Changwoo Lim
}
