% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exhaustive_tests.R
\name{exhaustive_tests}
\alias{exhaustive_tests}
\title{(main function) Runs exhaustive tests}
\usage{
exhaustive_tests(
  dset,
  modelType = "PCM",
  combos = NULL,
  scale_length = 4:length(dset),
  na.rm = TRUE,
  tests = c("no_test"),
  splitcr_mloef = NULL,
  splitcr_LR = NULL,
  splitcr_wald = NULL,
  icat_wald = FALSE,
  alpha = 0.1,
  bonf = FALSE,
  DIFvars = NULL,
  gap_prop = 0,
  extremes = TRUE,
  max_contrast = NULL,
  PSI = 0.8,
  ICs = FALSE,
  keep = FALSE,
  ignoreCores = 1,
  verbose = TRUE,
  ...,
  itemfit_param = NULL,
  estimation_param = NULL
)
}
\arguments{
\item{dset}{a data.frame containing the data}

\item{modelType}{a character value defining the rasch model to fit.
Possible values: RM, PCM, RSM}

\item{combos}{either 1) a list of item combinations to be tested,
e.g. from \link{apply_combo_rules} or the passed_combos slot of an object
 of \link{passed_exRa-class} from a previous call to this function. Or 2)
  an object of \link{passed_exRa-class}. In this case, the previously fit
   models froms its passed_Models slot will also be used and will be
    passed to the test functions. This will speed up the analysis. If
     the parameter is NULL, all possible combinations of the items
      (columns) in dset will be tested}

\item{scale_length}{a numeric vector defining the length of the item
combinations to test}

\item{na.rm}{a boolean value. If TRUE, in the respective item combination
all cases with any NA are removed (na.omit). If FALSE, only cases
 with full NA responses are removed. NOTE: \link{test_mloef} currently
 does not allow for missing values. If \link{test_mloef} is under the
 tests to perform, na.rm will automatically be set TRUE for ALL tests.}

\item{tests}{a vector of characters defining the tests to perform.
Possible values: all_rawscores, test_itemfit, test_LR, test_mloef,
 test_waldtest, threshold_order, test_DIFtree, test_personsItems,
  test_respca, test_PSI. Tests will be performed in the given order.
  test_mloef is not available for pairwise estimation, threshold_order is
  not available (and not meaningful) for dichotomous models.}

\item{splitcr_mloef}{Split criterion to define
the item groups for test_mloef. "median" and "mean" split items in two
groups based on their items' raw scores median or mean. "random" (only
for 'psychotools' estimation) performs a random split (in this case, the
seed can be set with the "splitseed" argument of
\link{itemfit_control}. splitcr_mloef can also be a vector of length k
  (where k denotes the number of items) that takes two or more distinct
   values to define groups used for the Martin-Löf Test.}

\item{splitcr_LR}{Split criterion for subject raw score splitting for
test_LR. "median" uses the median as split criterion, "mean" performs a
  mean split, "random" (only for 'psychotools' or 'pairwise' estimation)
  performs a random split (in this case, the seed can be set with the
  "splitseed" argument of \link{itemfit_control}. splitcr_LR can also be a
  vector which assigns each person to a certain subgroup (typically an
  external criterion). This vector can be numeric, character or a factor.}

\item{splitcr_wald}{Split criterion for subject raw score splitting for
test_waldtest. "median" uses the median as split criterion, "mean"
performs a mean-split, "random" (only for 'psychotools' or 'pairwise'
estimation) performs a random split (in this case, the seed can be set
with the "splitseed" argument of \link{itemfit_control}. Optionally
splitcr_wald can also be a dichotomous vector which assigns each person
to a certain subgroup (e.g., following an external criterion). This
vector can be numeric, character or a factor.}

\item{icat_wald}{a boolean value indicating if the waldtest will be
conducted on item level (TRUE, default value) or on item category level.
This parameter only effects estimations using 'psychotools' or 'pairwise'
and will be ignored for eRm estimations.}

\item{alpha}{a numeric value for the alpha level. Will be ignored
for \link{test_itemfit} if use.pval in \link{itemfit_control} is FALSE}

\item{bonf}{a boolean value whether to use a Bonferroni correction.
Will be ignored if use.pval is FALSE}

\item{DIFvars}{a data.frame containing the variables and their data to use
for differential item functioning analysis with \link{test_DIFtree}}

\item{gap_prop}{a numeric value between 0 and 1 that sets the criterion
for the minimum proportion of neighboring person parameters with an
 item/threshold location in between. If set to 0, this criterion will not
  be checked (used in test_personsItems only)}

\item{extremes}{a boolean value indicating if a check for the
item/threshold locations left of the 2nd lowest and right of the
2nd highest person parameter (used in test_personsItems only).}

\item{max_contrast}{a numeric value defining the maximum loading of a
factor in the principal components analysis of the standardised residuals.
Only relevant, if test_respca is one of the tests.}

\item{PSI}{a numeric value defining the minimum value for the person-
separation-index (separation reliablility).}

\item{ICs}{a boolean value defining whether to compute information criteria
for the remaining models. You can add these later to the object of class
 \link{passed_exRa-class} by using the \link{add_ICs} function.}

\item{keep}{a boolean value difining whether des person parameters will be
part of the \link{passed_exRa-class} results object (TRUE) or not (FALSE).
Keeping the person parameters will result in shorter runtimes, if several
tests that need these parameters are used. On the other hand there will
be a largeramount of memeory usage.}

\item{ignoreCores}{a numeric value for the number of cpu cores to hold out
in parallelizing the test run.}

\item{verbose}{a boolean value. If set to FALSE, all output during the
analysis will be suppressed.}

\item{...}{arguments for \link{itemfit_control}
and \link{estimation_control}can be passed directly to this function.}

\item{itemfit_param}{a list from \link{itemfit_control} with options
for \link{test_itemfit}}

\item{estimation_param}{options for parameter estimation using
\link{estimation_control}}
}
\value{
an object of \link{passed_exRa-class}.
}
\description{
(main function) Runs exhaustive tests
}
\examples{
\donttest{
  library(exhaustiveRasch)
  data(ADL)
  passed <- exhaustive_tests(dset= ADL[c(1:4,7,12,14)],
    modelType= "RM", scale_length= 5, alpha=0.05,
    tests=c("test_LR", "test_itemfit", "test_respca"),
    splitcr_LR = ADL[,17], itemfit_param =
      itemfit_control(use.pval=FALSE, upperMSQ=1.5, lowerMSQ=0.5),
    estimation_param= estimation_control(
      est="psychotools"), verbose=FALSE)
}
}
