% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_volume.R
\name{dilate_mask_vol}
\alias{dilate_mask_vol}
\title{Dilate 3D mask}
\usage{
dilate_mask_vol(vol, n_dilate = 1, out_of_mask_val = NA, new_val = 1)
}
\arguments{
\item{vol}{The 3D array to dilate. The mask to dilate is defined by all
values not in \code{out_of_mask_val}.}

\item{n_dilate}{The number of layers to dilate the mask by. Default:
\code{1}.}

\item{out_of_mask_val}{A voxel is not included in the mask if and only if its
value is in this vector. Default: \code{NA}. If \code{vol} is simply a
logical array with \code{TRUE} values for in-mask voxels, use
\code{out_of_mask_val=FALSE}.}

\item{new_val}{Value for voxels newly added to the mask. Default: \code{1}.
If \code{vol} is simply a logical array with \code{TRUE} values for
in-mask voxels, use \code{new_val=1}.}
}
\value{
The dilated \code{vol}. It is the same as \code{vol}, but dilated
voxels are replaced with \code{new_val}.
}
\description{
Dilate a volumetric mask by a certain number of voxel layers. For each layer,
any out-of-mask voxel adjacent to at least one in-mask voxel is added to the
mask.
}
\details{
Diagonal voxels are not considered adjacent, i.e. the voxel at (0,0,0) is not
adjacent to the voxels at (1,1,0) or (1,1,1), although it is adjacent to
(1,0,0).
}
