% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmVaRDecomp.R
\name{fmVaRDecomp}
\alias{fmVaRDecomp}
\alias{fmVaRDecomp.tsfm}
\alias{fmVaRDecomp.sfm}
\alias{fmVaRDecomp.ffm}
\title{Decompose VaR into individual factor contributions}
\usage{
fmVaRDecomp(object, ...)

\method{fmVaRDecomp}{tsfm}(
  object,
  factor.cov,
  p = 0.05,
  type = c("np", "normal"),
  use = "pairwise.complete.obs",
  ...
)

\method{fmVaRDecomp}{sfm}(
  object,
  factor.cov,
  p = 0.05,
  type = c("np", "normal"),
  use = "pairwise.complete.obs",
  ...
)

\method{fmVaRDecomp}{ffm}(
  object,
  factor.cov,
  p = 0.05,
  type = c("np", "normal"),
  use = "pairwise.complete.obs",
  ...
)
}
\arguments{
\item{object}{fit object of class \code{tsfm}, \code{sfm} or \code{ffm}.}

\item{...}{other optional arguments passed to \code{\link[stats]{quantile}}.}

\item{factor.cov}{optional user specified factor covariance matrix with 
named columns; defaults to the sample covariance matrix.}

\item{p}{tail probability for calculation. Default is 0.05.}

\item{type}{one of "np" (non-parametric) or "normal" for calculating VaR. 
Default is "np".}

\item{use}{method for computing covariances in the presence of missing 
values; one of "everything", "all.obs", "complete.obs", "na.or.complete", or 
"pairwise.complete.obs". Default is "pairwise.complete.obs".}
}
\value{
A list containing 
\item{VaR.fm}{length-N vector of factor model VaRs of N-asset returns.}
\item{n.exceed}{length-N vector of number of observations beyond VaR for 
each asset.}
\item{idx.exceed}{list of numeric vector of index values of exceedances.}
\item{mVaR}{N x (K+1) matrix of marginal contributions to VaR.}
\item{cVaR}{N x (K+1) matrix of component contributions to VaR.}
\item{pcVaR}{N x (K+1) matrix of percentage component contributions to VaR.}
Where, \code{K} is the number of factors and N is the number of assets.
}
\description{
Compute the factor contributions to Value-at-Risk (VaR) of 
assets' returns based on Euler's theorem, given the fitted factor model. 
The partial derivative of VaR w.r.t. factor beta is computed as the expected 
factor return given fund return is equal to its VaR and approximated by a
kernel estimator. Option to choose between non-parametric and Normal.
}
\details{
The factor model for an asset's return at time \code{t} has the 
form \cr \cr \code{R(t) = beta'f(t) + e(t) = beta.star'f.star(t)} \cr \cr 
where, \code{beta.star=(beta,sig.e)} and \code{f.star(t)=[f(t)',z(t)]'}. By 
Euler's theorem, the VaR of the asset's return is given by: 
\cr \cr \code{VaR.fm = sum(cVaR_k) = sum(beta.star_k*mVaR_k)} \cr \cr 
where, summation is across the \code{K} factors and the residual, 
\code{cVaR} and \code{mVaR} are the component and marginal 
contributions to \code{VaR} respectively. The marginal contribution to VaR 
is defined as the expectation of \code{F.star}, conditional on the loss 
being equal to \code{VaR.fm}. This is approximated as described in 
Epperlein & Smillie (2006); a triangular smoothing kernel is used here. 

Refer to Eric Zivot's slides (referenced) for formulas pertaining to the 
calculation of Normal VaR (adapted from a portfolio context to factor models)
}
\examples{
# Time Series Factor Model

 # load data
data(managers, package = 'PerformanceAnalytics')
colnames(managers)
 # Make syntactically valid column names
colnames(managers) <- make.names( colnames(managers))
colnames(managers)

fit.macro <- fitTsfm(asset.names=colnames(managers[,(1:6)]),
                     factor.names=colnames(managers[,(7:8)]), 
                     data=managers)
                     
VaR.decomp <- fmVaRDecomp(fit.macro)

# get the component contributions
VaR.decomp$cVaR

}
\references{
Hallerback (2003). Decomposing Portfolio Value-at-Risk: A General Analysis. 
The Journal of Risk, 5(2), 1-18.

Meucci, A. (2007). Risk contributions from generic user-defined factors. 
RISK-LONDON-RISK MAGAZINE LIMITED-, 20(6), 84. 

Yamai, Y., & Yoshiba, T. (2002). Comparative analyses of expected shortfall 
and value-at-risk: their estimation error, decomposition, and optimization. 
Monetary and economic studies, 20(1), 87-121.
}
\seealso{
\code{\link{fitTsfm}}
for the different factor model fitting functions.

\code{\link{fmSdDecomp}} for factor model SD decomposition.
\code{\link{fmEsDecomp}} for factor model ES decomposition.
}
\author{
Eric Zivot, Yi-An Chen and Sangeetha Srinivasan
}
