% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.tsfmUpDn.R
\name{predict.tsfmUpDn}
\alias{predict.tsfmUpDn}
\title{Predicts asset returns based on a fitted up and down market time series factor model}
\usage{
\method{predict}{tsfmUpDn}(object, ...)
}
\arguments{
\item{object}{an object of class \code{tsfmUpDn} produced by \code{fitTsfmUpDn}.}

\item{...}{optional arguments passed to \code{predict.lm} or
\code{\link[robustbase]{predict.lmrob}}, such as \code{se.fit}, or, to 
\code{\link[lars]{predict.lars}} such as \code{mode}.}
}
\value{
\code{predict.tsfmUpDm} produces a list of \code{Up} and \code{Dn}. Both \code{Up} and \code{Dn} contain a 
vector or a matrix of predictions.
}
\description{
S3 \code{predict} method for object of class \code{tsfmUpDn}. It 
calls the \code{predict.tsfm} method for a list object of \code{Up} and \code{Dn}
}
\examples{
 # load data
data(managers, package = 'PerformanceAnalytics')

# fit the factor model with LS. example: Up and down market factor model with LS fit
fitUpDn <- fitTsfmUpDn(asset.names = colnames(managers[,(1:6)]),
                       mkt.name = "SP500 TR",
                       data = managers, 
                       fit.method = "LS")
 
predict(fitUpDn)

}
\seealso{
\code{\link{predict.tsfm}},\code{\link{fitTsfmUpDn}}, \code{\link{summary.tsfmUpDn}}
}
\author{
Yi-An Chen and Sangeetha Srinivasan
}
