% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{fmm_to_spam}
\alias{fmm_to_spam}
\title{Convert Matrix Market File to spam Sparse Matrix}
\usage{
fmm_to_spam(filename)
}
\arguments{
\item{filename}{The name of the input Matrix Market file to be read.}
}
\value{
A spam object containing the data read from the Matrix Market file.
}
\description{
This function reads a Matrix Market file and converts it to a
sparse matrix using the spam package.
}
\examples{
\dontshow{if (requireNamespace("spam", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sample_sparse <- Matrix::Matrix(c(1, 0, 0, 2), nrow = 2, sparse = TRUE)
tmp <- tempfile(fileext = ".mtx")
write_fmm(sample_sparse, tmp)
sp <- fmm_to_spam(tmp)
\dontshow{\}) # examplesIf}
}
