% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00d_GRaster_class.r
\name{.makeGRaster}
\alias{.makeGRaster}
\title{Create a GRaster}
\usage{
.makeGRaster(src, names = "raster", levels = "", ac = NULL, fail = TRUE)
}
\arguments{
\item{src}{Character (name of the raster in **GRASS) or a \code{rastInfo} object.}

\item{names}{Character: Name of the raster.}

\item{levels}{\code{NULL} (default), a \code{data.frame}, \code{data.table}, an empty string (\code{""}), or a list of \code{data.frame}s, \code{data.table}s, and/or empty strings: These become the raster's \code{\link[=levels]{levels()}}. If \code{""}, then no levels are defined.}

\item{ac}{Vector of numeric/integer values >=1, or \code{NULL} (default): Active category column (offset by 1, so 1 really means the second column, 2 means the third, etc.). A value of \code{NULL} uses an automated procedure to figure it out.}

\item{fail}{Logical: If \code{TRUE} (default), and the raster either has a 0 east-west or north-south extent, then exit the function with an error. If \code{fail} is \code{FALSE}, then display a warning and return \code{NULL}.}
}
\value{
A \code{GRaster}.
}
\description{
Create a \code{GRaster} from a raster existing in the current \strong{GRASS} session.
}
\seealso{
\code{\link[=.makeGVector]{.makeGVector()}}
}
\keyword{internal}
