% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_logic.r
\name{Logic,GRaster,GRaster-method}
\alias{Logic,GRaster,GRaster-method}
\alias{Logic-methods}
\alias{Logic,logical,GRaster-method}
\alias{Logic,GRaster,logical-method}
\alias{Logic,GRaster,numeric-method}
\alias{Logic,numeric,GRaster-method}
\alias{Logic,GRaster,integer-method}
\alias{Logic,integer,GRaster-method}
\title{Logic-methods operations on GRasters}
\usage{
\S4method{Logic}{GRaster,GRaster}(e1, e2)

\S4method{Logic}{logical,GRaster}(e1, e2)

\S4method{Logic}{GRaster,logical}(e1, e2)

\S4method{Logic}{GRaster,numeric}(e1, e2)

\S4method{Logic}{numeric,GRaster}(e1, e2)

\S4method{Logic}{GRaster,integer}(e1, e2)

\S4method{Logic}{integer,GRaster}(e1, e2)
}
\arguments{
\item{e1, e2}{Two \code{GRaster}s, or a \code{GRaster} and a logical value (\code{TRUE} or \code{FALSE}, but not \code{NA}), a numeric value that is 0 or 1 (but not \code{NA_real_}), or an integer value that is 0 or 1 (but not \code{NA_integer_}).}
}
\value{
A binary \code{GRaster} (1 ==> \code{TRUE}, 0 ==> \code{FALSE}, plus \code{NA} when comparison results in \code{NA}).
}
\description{
You can do logical operations on \code{GRaster}s. A cell with a value of 1 is interpreted as \code{TRUE}, and a value of 0 is interpreted as \code{FALSE}. You can compare:
\itemize{
\item A \code{GRaster} to another \code{GRaster}
\item A \code{GRaster} to a logical value (\code{TRUE} or \code{FALSE}, but not \code{NA}--see \code{\link[=not.na]{not.na()}})
\item A \code{GRaster} to a numeric or integer value that is 0 or 1
}

Operators include:
\itemize{
\item \code{|}: \code{TRUE} if either condition is \code{TRUE} (or 1), but returns \code{NA} if either condition is \code{NA}.
\item \code{&}: \code{TRUE} if both conditions are \code{TRUE} (or 1), but \code{NA} if either is \code{NA}.
}
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)
elevs <- c(elev, elev, log10(elev) - 1, sqrt(elev))
names(elevs) <- c("elev1", "elev2", "log_elev", "sqrt_elev")

elev
elevs

# Comparisons
elev < 100
elev <= 100
elev == 100
elev != 100
elev > 100
elev >= 100

elev + 100 < 2 * elev

elevs > 10
10 > elevs

# logic
elev < 10 | elev > 200
elev < 10 | cos(elev) > 0.9

elev < 10 | TRUE
TRUE | elev > 200

elev < 10 | FALSE
FALSE | elev > 200

elev < 10 & cos(elev) > 0.9

elev < 10 & TRUE
TRUE & elev > 200

elev < 10 & FALSE
FALSE & elev > 200

}
}
