% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_information.R
\name{information}
\alias{information}
\title{mfc item and test information}
\usage{
information(x, approach, theta, information, items)
}
\arguments{
\item{x}{returned object}

\item{approach}{Estimation approaches used for parameters. They can be "direct", which is direct approach, and "two step", which is two step approach. The default is direct approach.}

\item{theta}{Type of theta values used. They can be "quadrature", which is -3, -2.9, -2.8, -2.7...2.9, 3, and "estimated", which is estimated theta values. The default is quadrature.}

\item{information}{Types of information.They can be "item", which is overall item information, and "test", which is overall test information. The default is overall item information.}

\item{items}{The items of which information to be calculated. The default is all the items.}
}
\value{
Selected item information or overall test information
}
\description{
This function calculates mfc item and test information.
}
\examples{
\donttest{
# long running time
Data <- c(1,2,2,1,1,1,1,1,NA,1,2,1,1,2,1,1,2,2,NA,2,2,2,1,1,1,2,1,1,1,1,2,1,1,1,2,1,1,2,1,1)
Data <- matrix(Data,nrow = 10)
pairmap <- c(1,3,5,7,2,4,6,8)
pairmap <- matrix(pairmap,ncol = 2)
ind <- c(1,2,1,2,1,2,2,1)
ParInits <- c(1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, -1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1)
ParInits <- matrix(ParInits, ncol = 3)
mod <- fcirt(fcirt.Data=Data,pairmap=pairmap,ind=ind,
ParInits=ParInits,iter=1000,warmup=500,chains=2)
information(mod, approach="direct", theta="quadrature", information="item", items=1)}
}
