% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normaliseDensities.R
\name{normaliseDensities}
\alias{normaliseDensities}
\title{Normalise Densities}
\usage{
normaliseDensities(dmatrix, dSup = 1:ncol(dmatrix))
}
\arguments{
\item{dmatrix}{Matrix with rows representing distinct densities on dSup - all entries must be nonnegative}

\item{dSup}{Support (grid) for Density domain}
}
\value{
matrix 'dmatrix' consisting of rows of input of the same name that have been normalised to have integral 1
}
\description{
Preprocessing function to ensure densities integrate to 1
}
\details{
Uses trapezoidal integration to normalise the densities to have integral 1
}
\examples{
## Normalise collection of truncated normal densities

mu <- seq(-2, 2, by = 0.5)
dSup = seq(-3, 3, length.out = 101)
y <- t(sapply(mu, function(m) dnorm(x = dSup, mean = m)))

# Should return warnings about densities not integrating to 1
lqd = MakeLQDsample(dmatrix = y, dSup = dSup)

# Normalise and rerun without warning
dens <- normaliseDensities(dmatrix = y, dSup = dSup)
lqd = MakeLQDsample(dmatrix = dens, dSup = dSup)


}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
