% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLMCI.R
\name{FLMCI}
\alias{FLMCI}
\title{Confidence Intervals for Functional Linear Models.}
\usage{
FLMCI(Y, X, level = 0.95, R = 999, optnsListY = NULL, optnsListX = NULL)
}
\arguments{
\item{Y}{Either an n-dimensional vector whose elements consist of scalar responses, or a list which contains functional responses in the form of a list LY and the time points LT at which they are observed (i.e., \code{list(Ly = LY,Lt = LT)}).}

\item{X}{A list of lists which contains the observed functional predictors list Lxj and the time points list Ltj at which they are observed. It needs to be of the form \code{list(list(Ly = Lx1,Lt = Lxt1),list(Ly = Lx2,Lt = Lxt2),...)}.}

\item{level}{A number taking values in [0,1] determining the confidence level. Default: 0.95.}

\item{R}{An integer holding the number of bootstrap replicates. Default: 999.}

\item{optnsListY}{A list of options control parameters for the response specified by \code{list(name=value)}. See 'Details' in FPCA.}

\item{optnsListX}{A list of options control parameters for the predictors specified by \code{list(name=value)}. See 'Details' in FPCA.}
}
\value{
A list containing the following fields: 
\item{CI_alpha}{CI for the intercept function --- A data frame holding three variables: 
\code{CI_grid} --- the time grid where the CIs are evaluated,
\code{CI_lower} and \code{CI_upper} --- the lower and upper bounds of the CIs 
for the intercept function on \code{CIgrid}.}
\item{CI_beta}{ A list containing CIs for the slope functions --- the length of
the list is the same as the number of covariates. Each list contains the following fields:
A data frame holding three variables: \code{CI_grid} --- the time grid where the CIs are evaluated,
\code{CI_lower} and \code{CI_upper} --- the lower and upper bounds of the CIs 
for the coefficient function on \code{CIgrid} for \eqn{j = 1,2,\dots}.}
\item{level}{The confidence level of the CIs.}
}
\description{
Bootstrap pointwise confidence intervals for the coefficient functions in functional linear models.
}
\details{
If measurement error is assumed, the diagonal elements of the raw covariance will be removed. This could result in highly unstable estimate 
if the design is very sparse, or strong seasonality presents. 
WARNING! For very sparse functional data, setting \code{measurementError=TRUE} is not recommended.
}
