% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureCorMatrix.R
\name{featureCorMatrix}
\alias{featureCorMatrix}
\title{Calculates the Feature Correlation Matrix}
\usage{
featureCorMatrix(dataframe, absoluteValues = FALSE)
}
\arguments{
\item{dataframe}{A data.frame}

\item{absoluteValues}{A flag stating if only positive correlations should be
returned}
}
\value{
A correlation matrix
}
\description{
\code{featureCorMatrix} returns a correlation matrix between all features
}
\details{
The function selects automatically the appropriate correlation
coefficient regarding the storage type of both variables
- If both variable are numerical ones, the Pearson product-moment correlation
coefficient will be chosen
- If both variables are categorical, Cramer's V will be used
- If one variable is a numerical and the other a categorical one,
the Intraclass correlation will be calculated
}
\examples{
featureCorMatrix(dataframe = iris, absoluteValues = TRUE)
}
