% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{felt_add_library_layer}
\alias{felt_add_library_layer}
\title{Add layer to library}
\usage{
felt_add_library_layer(map_id, layer_id, name = NULL, clean = TRUE)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{layer_id}{character, layer identifier from url, from \code{felt_get_map()}}

\item{name}{character, name to save the layer under. Optional.}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
a \link[tibble:tibble]{tibble::tibble} if \code{clean = TRUE}, otherwise a list
}
\description{
Add layer to library
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
felt_add_library_layer(map_id = 'TBI8sDkmQjuK2GX9CSiHiUA',
                      layer_id = '4Lc7RaEyRP2LfARGmR6e4C',
                      name = paste0('Test layer ', Sys.time()))
\dontshow{\}) # examplesIf}
}
