% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_admin.R
\name{bkg_admin}
\alias{bkg_admin}
\alias{bkg_admin_archive}
\alias{bkg_admin_highres}
\title{Administrative areas}
\usage{
bkg_admin(
  ...,
  level = "krs",
  scale = c("250", "1000", "2500", "5000"),
  key_date = c("0101", "1231"),
  bbox = NULL,
  poly = NULL,
  predicate = "intersects",
  filter = NULL,
  epsg = 3035,
  properties = NULL,
  max = NULL
)

bkg_admin_archive(
  level = "krs",
  scale = c("250", "1000", "2500", "5000"),
  key_date = c("0101", "1231"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_admin_highres(
  level = "krs",
  year = "latest",
  layer = NULL,
  timeout = 600,
  update_cache = FALSE
)
}
\arguments{
\item{...}{Used to construct CQL filters. Dot arguments accept an R-like
syntax that is converted to CQL queries internally. These queries basically
consist of a property name on the left, an aribtrary vector on the right,
and an operator that links both sides. If multiple queries are provided,
they will be chained with \code{AND}. The following operators and their
respective equivalents in CQL and XML are supported:

\tabular{lll}{
\strong{R} \tab \strong{CQL} \tab \strong{XML}\cr
\code{==} \tab \code{=} \tab \code{PropertyIsEqualTo}\cr
\code{!=} \tab \code{<>} \tab \code{PropertyIsNotEqualTo}\cr
\code{<} \tab \code{<} \tab \code{PropertyIsLessThan}\cr
\code{>} \tab \code{>} \tab \code{PropertyIsGreaterThan}\cr
\code{>=} \tab \code{>=} \tab \code{PropertyIsGreaterThanOrEqualTo}\cr
\code{<=} \tab \code{<=} \tab \code{PropertyIsLessThanOrEqualTo}\cr
\code{\%LIKE\%} \tab \code{LIKE} \tab \code{PropertyIsLike}\cr
\code{\%ILIKE\%} \tab \code{ILIKE} \tab\cr
\code{\%in\%} \tab \code{IN} \tab \code{PropertyIsEqualTo} and \code{Or}
}

To construct more complex queries, you can use the \code{filter} argument
to pass CQL queries directly. Also note that you can switch between
CQL and XML queries using \code{options(ffm_query_language = "xml")}.
See also \code{\link{wfs_filter}}.}

\item{level}{Administrative level to download. Must be one of
\code{"sta"} (Germany), \code{"lan"} (federal states), \code{"rbz"}
(governmental districts), \code{"krs"} (districts), \code{"vwg"}
(administrative associations), \code{"gem"} (municipalities),
\code{"li"} (boundary lines), or \code{"pk"} (municipality centroids).
Defaults to districts.}

\item{scale}{Scale of the geometries. Can be \code{"250"}
(1:250,000), \code{"1000"} (1:1,000,000), \code{"2500"} (1:2,500,000)
or \code{"5000"} (1:5,000,000). If \code{"250"}, population data is included
in the output. Defaults to \code{"250"}.}

\item{key_date}{For \code{resolution \%in\% c("250", "5000")}, specifies the key
date from which to download administrative data. Can be either \code{"0101"}
(January 1) or \code{"1231"} (December 31). The latter is able to
georeference statistical data while the first integrates changes made
in the new year. If \code{"1231"}, population data is attached, otherwise
not. Note that population data is not available at all scales (usually
250 and 1000). Defaults to "0101".}

\item{bbox}{An sf geometry or a boundary box vector of the format
\code{c(xmin, ymin, xmax, ymax)}. Used as a geometric filter to include
only those geometries that relate to \code{bbox} according to the predicate
specified in \code{predicate}. If an sf geometry is provided, coordinates
are automatically transformed to ESPG:25832 (the default CRS), otherwise
they are expected to be in EPSG:25832.}

\item{poly}{An sf geometry. Used as a geometric filter to include
only those geometries that relate to \code{poly} according to the predicate
specified in \code{predicate}. Coordinates are automatically transformed to
ESPG:25832 (the default CRS).}

\item{predicate}{A spatial predicate that is used to relate the output
geometries with the object specified in \code{bbox} or \code{poly}. For
example, if \code{predicate = "within"}, and \code{bbox} is specified,
returns only those geometries that lie within \code{bbox}. Can be one of
\code{"equals"}, \code{"disjoint"}, \code{"intersects"}, \code{"touches"},
\code{"crosses"}, \code{"within"}, \code{"contains"}, \code{"overlaps"},
\code{"relate"}, \code{"dwithin"}, or \code{"beyond"}. Defaults to
\code{"intersects"}.}

\item{filter}{A character string containing a valid CQL or XML filter. This
string is appended to the query constructed through \code{...}. Use this
argument to construct more complex filters. Defaults to \code{NULL}.}

\item{epsg}{An EPSG code specifying a coordinate reference system of the
output. If you're unsure what this means, try running
\code{sf::st_crs(...)$epsg} on a spatial object that you are working with.
Defaults to 3035.}

\item{properties}{Vector of columns to include in the output.}

\item{max}{Maximum number of results to return.}

\item{year}{Version year of the dataset. You can use \code{latest} to
retrieve the latest dataset version available on the BKG's geodata center.
Older versions can be browsed using the
\href{https://daten.gdz.bkg.bund.de/produkte/}{archive}.}

\item{timeout}{Timeout value for the data download passed to
\code{\link[httr2]{req_timeout}}. Adjust this if your internet connection is
slow or you are downloading larger datasets.}

\item{update_cache}{By default, downloaded files are cached in the
\code{tempdir()} directory of R. When downloading the same data again,
the data is not downloaded but instead taken from the cache. Sometimes
this can be not the desired behavior. If you want to overwrite the cache,
pass \code{TRUE}. Defaults to \code{FALSE}, i.e. always adopt the cache
if possible.}

\item{layer}{The \code{vg25} product used in \code{bkg_admin_highres}
contains a couple of metadata files. You can set a layer name to read these
files, otherwise the main file is read.}
}
\value{
An sf dataframe with multipolygon geometries and different columns
depending on the geometry type.
Areal geometries generally have the following columns:
\itemize{
\item{\code{objid}}: Unique object identifier
\item{\code{beginn}}: Creation of the object in the DLM
\item{\code{ade}}: Integer representing the administrative level. Can
be one of \itemize{
\item{1: Germany}
\item{2: Federal state}
\item{3: Governmental district}
\item{4: District}
\item{5: Administrative association}
\item{6: Municipality}
}
\item{\code{gf}}: Integer representing the geofactor; whether an area is
"structured" or not. Land is structured if it is part of a state or other
administrative unit but is not further divided into administrative units.
Can be one of \itemize{
\item{1: Unstructured, waterbody}
\item{2: Structured, waterbody}
\item{3: Unstructured, land}
\item{4: Structured, land}
}
\item{\code{bsg}}: Special areas, can be 1 (Germany) or 9 (Lake Constance)
\item{\code{ars}}: Territorial code (Amtlicher Regionalschlüssel).
The ARS is stuctured hierarchically as follows: \itemize{
\item{Position 1-2: Federal state}
\item{Position 3: Government region}
\item{Position 4-5: District}
\item{Position 6-9: Administrative association}
\item{Position 10-12: Municipality}
}
\item{\code{ags}}: Official municipality key (Amtlicher Gemeindeschlüssel).
Related to the ARS but shortened to omit position 6 to 9. Structured as
follows: \itemize{
\item{Position 1-2: Federal state}
\item{Position 3: Government region}
\item{Position 4-5: District}
\item{Position 6-8: Municipality}
}
\item{\code{sdv_ars}}: ARS of the seat of administration
\item{\code{gen}}: Geographical name
\item{\code{bez}}: Label of the administrative unit
\item{\code{ibz}}: Identifier of the label
\item{\code{bem}}: Comment on the label
\item{\code{nbd}}: Formation of the geographical name. Can be "ja" if
the label is part of the name or "nein" otherwise.
\item{\code{nuts}}: NUTS identifier based on the Eurostat regional
classification
\item{\code{ars_0}}: ARS identifier with trailing zeroes
\item{\code{ags_0}}: AGS identifier with trailing zeroes
\item{\code{wsk}}: Legally relevant date for the effectiveness of administrative changes
\item{\code{sn_l}}: Federal state component of the ARS
\item{\code{sn_r}}: Governmental district component of the ARS
\item{\code{sn_k}}: District component of the ARS
\item{\code{sn_v1}}: First part of the administrative association component of the ARS
\item{\code{sn_v2}}: Second part of the administrative association component of the ARS
\item{\code{sn_g}}: Municipality component of the ARS
\item{\code{fk_3}}: Purpose of the third key position. If \code{"R"}, indicates the
government region, if \code{"K"}, indicates the district
\item{\code{dkm_id}}: Identifier in the digital landscape model (DLM250)
\item{\code{ewz}}: Number of inhabitants
\item{\code{kfl}}: Land register area in square kilometers
}

Boundary geometries (\code{"li"}) can have additional columns:
\itemize{
\item{\code{agz}}: Type of border. Can be one of \itemize{
\item{1: National border}
\item{2: State border}
\item{3: Governmental district border}
\item{4: District border}
\item{5: Administrative association border}
\item{6: Municipality border}
\item{9: Coastline}
}
\item{\code{rdg}}: Legal definition of a border. Can be 1 (determined),
2 (not determined) or 9 (coastline)
\item{\code{gm5}}: Border characteristic of administrative association
borders (AGZ 5). Used to describe the purpose of these borders. Can
be 0 (characteristics by AGZ) or 8 (non-association border)
\item{\code{gmk}}: Border characteristic by coast/ocean. Specifies whether
a border runs a long a waterbody. Can be one of \itemize{
\item{7: borders on the ocean}
\item{8: auxiliary borders on the ocean}
\item{9: borders at the coastline}
\item{0: no characteristics}
}
\item{\code{dlm_id}}: Identifier in the digital landscape model (DLM250)
}

Point geometries (\code{"pk"}) have the following additional columns:
\itemize{
\item{\code{otl}}: Name of the locality in the digital landscale model (DLM250)
\item{\code{lon_dez}}: Decimal longitude
\item{\code{lat_dez}}: Decimal latitude
\item{\code{lon_gms}}: Geographical longitude
\item{\code{lat_gms}}: Geographical latitude
}
}
\description{
Retrieve polygon geometries of administrative areas in Germany. All
administrative levels are supported at different spatial resolutions.

\itemize{
\item{\code{bkg_admin} interfaces a WFS that allows prefiltering but
provides no historical data and allows a maximum scale of 1:250,000.}
\item{\code{bkg_admin_archive} allows access to historical data but
has no prefiltering.}
\item{\code{bkg_admin_highres} (\code{vg25}) allows access to
high-resolution data going as low as 1:25,000 but allows no prefiltering.}
}

These functions interface the \code{vg*} products of the BKG.
}
\section{Query language}{

By default, WFS requests use CQL (Contextual Query Language) queries for
simplicity. CQL queries only work together with GET requests. This means
that when the URL is longer than 2048 characters, they fail.
While POST requests are much more flexible and able to accommodate long
queries, XML is really a pain to work with and I'm not confident in my
approach to construct XML queries. You can control whether to send GET or
POST requests by setting \code{options(ffm_query_language = "XML")}
or \code{options(ffm_query_language = "CQL")}.
}

\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")()) withAutoprint(\{ # examplesIf}
# You can use R-like operators to query the WFS
bkg_admin(ags \%LIKE\% "05\%") # districts in NRW
bkg_admin(sn_l == "05") # does the same thing
bkg_admin(gen \%LIKE\% "Ber\%") # districts starting with Ber*

# To query population and area, the key date must be December 31
bkg_admin(ewz > 500000, key_date = "1231") # districts over 500k people
bkg_admin(kfl <= 100, key_date = "1231") # districts with low land register area

# Using `gf == 9`, you can exclude waterbodies like oceans
states <- bkg_admin(scale = "5000", level = "lan", gf == 9)
plot(states$geometry)

# Download historical data
bkg_admin_archive(scale = "5000", level = "sta", year = "2021")

\donttest{
# Download high-resolution data (takes a long time!)
bkg_admin_highres(level = "lan")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://sgx.geodatenzentrum.de/web_public/gdz/dokumentation/deu/vg250.pdf}{\code{vg250-ew} documentation}

\href{https://mis.bkg.bund.de/trefferanzeige?docuuid=4A9DCE2B-DCCA-4939-BA01-54364D11C46D}{\code{vg250-ew} MIS record}

\code{\link{bkg_nuts}} for retrieving EU administrative areas

\code{\link{bkg_admin_hierarchy}} for the administrative hierarchy

\code{\link{bkg_ror}}, \code{\link{bkg_grid}}, \code{\link{bkg_kfz}},
\code{\link{bkg_authorities}} for non-administrative regions

Datasets: \code{\link{admin_data}}, \code{\link{nuts_data}}
}
