% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{A_Data}
\alias{A_Data}
\title{Amputee Combined Gait Data}
\format{
A list containing the 18 kinematic variables with each list containing a data.frame with N rows and T variables, where N is 
the total number of subjects and T is the total number of time points. 
\describe{
  \item{Left Pelvis Angles D2}{numeric data.frame with N rows and T variables}
  \item{Left Pelvis Angles D1}{numeric data.frame with N rows and T variables}
  \item{Left Pelvis Angles D3}{numeric data.frame with N rows and T variables}
  \item{Left Hip Angles D2}{numeric data.frame with N rows and T variables}
  \item{Left Hip Angles D1}{numeric data.frame with N rows and T variables}
  \item{Left Hip Angles D3}{numeric data.frame with N rows and T variables}
  \item{Left Knee Angles}{numeric data.frame with N rows and T variables}
  \item{Left Ankle Angle}{numeric data.frame with N rows and T variables}
  \item{Left Foot Progression Angle}{numeric data.frame with N rows and T variables}
  \item{Right Pelvis Angles D2}{numeric data.frame with N rows and T variables}
  \item{Right Pelvis Angles D1}{numeric data.frame with N rows and T variables}
  \item{Right Pelvis Angles D3}{numeric data.frame with N rows and T variables}
  \item{Right Hip Angles D2}{numeric data.frame with N rows and T variables}
  \item{Right Hip Angles D1}{numeric data.frame with N rows and T variables}
  \item{Right Hip Angles D3}{numeric data.frame with N rows and T variables}
  \item{Right Knee Angles}{numeric data.frame with N rows and T variables}
  \item{Right Ankle Angle}{numeric data.frame with N rows and T variables}
  \item{Right Foot Progression Angle}{numeric data.frame with N rows and T variables}
}
}
\source{
Internal gait study
}
\usage{
A_Data
}
\description{
Kinematic data for 18 individuals with unilateral above-knee amputations and 42 healthy controls.
Each entry contains 18 kinematic variables measured at 1% intervals over the full gait cycle. 
control data precedes amputee data. Amputee data from Hood et al. (2020); control data from
Fukuchi et al. (2018).
}
\examples{
# Load the Data
data(A_Data)
}
\keyword{datasets}
