% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FGDI.R
\name{FGDI}
\alias{FGDI}
\title{Compute the Functional Gait Deviation Index (FGDI)}
\usage{
FGDI(G, ID, PVE_I)
}
\arguments{
\item{G}{A list of matrices representing joint kinematic data. Each list contains the pelvic and hip angles across all three planes, knee flexion/extension, 
 ankle dorsiflexion/plantarflexion, and foot internal/external rotation. The Left side is first and then the right side. It is important to
note that since the pelvis is common to both sides, it is appropriate to include pelvic kinematics from only one side.}

\item{ID}{A vector of group labels (e.g., "Case", "Control").}

\item{PVE_I}{A numeric value (0–1) for cumulative proportion of variance explained.}
}
\value{
A list with the following elements:
\describe{
  \item{SFGDIB}{A numeric vector of scaled FGDI scores for both the left and right side.}
  \item{zFGDIU}{A matrix containing the standardized FGDI scores for each kinematic variable.}
  \item{zFGDI}{A numeric vector of standardized combined FGDI scores.}
  \item{Fits}{A list containing the approximated gait functions evaluated across the gait cycle for each kinematic variable.}
  \item{RMSE}{A numeric vector containing the root mean squared error of the approximated gait functions.}
  \item{SFGDIL}{A numeric vector of standardized FGDI scores for the left side.}
  \item{SFGDIR}{A numeric vector of standardized FGDI scores for the right side.}
  \item{PVE}{A numeric vector with the percentage of variation explained by FPCs for the combined data.}
  \item{PVEL}{A numeric vector with the percentage of variation explained by FPCs for the data on the left side.}
  \item{PVER}{A numeric vector with the percentage of variation explained by FPCs for the data on the right side.}
  \item{UPVE}{A matrix with the percentage of variation explained by FPCs for each kinematic variable.}
  \item{M}{The choosen number of FPCs for the combined data.}
  \item{M1}{The choosen number of FPCs for the data on the left side.}
  \item{M2}{The choosen number of FPCs for the data on the right side.}
  \item{NPC}{The choosen number of FPCs for each kinematic variable.}
}

#' @examples
data(A_Data)
FGDI_out <- FGDI(A_Data, ID = rep(c("Case", "Control"), times = c(18, 42)), PVE_I = 0.99)
FGDI_out$SFGDIL
}
\description{
Computes univariate and multivariate FGDI scores from gait data matrices.
}
\references{
Minhas, S.K., Sangeux, M., Polak, J., & Carey, M. (2025). The Functional Gait Deviation Index. 
Journal of Applied Statistics.
}
