% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gait_comparison.R
\name{plot_gait_comparison}
\alias{plot_gait_comparison}
\title{Plot Gait Curves with FGDI Overlay}
\usage{
plot_gait_comparison(joint_index, title, FGDI, Data, ID, combined)
}
\arguments{
\item{joint_index}{Index of the joint angle to plot.}

\item{title}{Title for the plot.}

\item{FGDI}{Output list from FGDI() function.}

\item{Data}{List of matrices containing the gait data.}

\item{ID}{Subject group labels.}

\item{combined}{Logical indicating if you want to see the combined FGDI results (TRUE). This approach yields a measure
of severity by collectively considering both legs, and displays the maximum gait abnormality. If FALSE
the max gait pathology is displayed for each leg individually left in green and right in blue.}
}
\value{
A ggplot object.
}
\description{
Plots gait curves comparing healthy controls to individuals with highest deviation.
}
\examples{
data(A_Data)
data(A_data_info)
ID <- c(rep("Case", 18), rep("Control", 42))
fgdi_out <- FGDI(A_Data, ID, PVE_I = 0.99)
plot_gait_comparison(1, "Pelvis Tilt", fgdi_out, A_Data, ID, combined=FALSE)
}
