% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filename.R
\name{as.character.filename}
\alias{as.character.filename}
\title{Coerce a character to a filename}
\usage{
\method{as.character}{filename}(x, tag.char = NULL, simplify = FALSE, sanitize = TRUE, ...)
}
\arguments{
\item{x}{a \code{filename} object}

\item{tag.char}{character to delimit tags, defaults to \code{'_'}}

\item{simplify}{if \code{TRUE}, all timestamps are omitted}

\item{sanitize}{if \code{TRUE}, file name is sanitized by removing
problematic characters, replacing whitespace, and
converting to lowercase}

\item{...}{unused arguments}
}
\value{
a \code{character} vector
}
\description{
This function coerces a \code{filename} into a character.
}
\examples{
x <- "data_post_2011-01-02.txt"
fn <- as.filename(x)
print(as.character(fn))

}
