% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_exp_map.R
\name{fire_exp_map}
\alias{fire_exp_map}
\title{Visualize exposure in a map}
\usage{
fire_exp_map(
  exposure,
  aoi,
  classify,
  class_breaks,
  title = "Wildfire Exposure"
)
}
\arguments{
\item{exposure}{SpatRaster (e.g. from \code{\link[=fire_exp]{fire_exp()}})}

\item{aoi}{(Optional) SpatVector of an area of interest to mask exposure}

\item{classify}{character, either \code{"local"}, \code{"landscape"}, or \code{"custom"},
to specify classification scheme to use. The default is \code{"local"}.
If set to \code{"custom"}: the parameter \code{class_breaks} must be used.}

\item{class_breaks}{vector of numeric values between 0-1 of the upper limits
of each custom class. Ignored unless \code{classify = "custom"}. See details.}

\item{title}{(Optional) String. A custom title for the plot. The default
is \code{"Wildfire exposure"}}
}
\value{
a map is returned as a tmap object.
}
\description{
\code{fire_exp_map()} produces a map with sensible defaults that can
be customized.
}
\details{
This function returns a map with basic cartographic elements and a
standardized colour scale. .

The plot is returned as a tmap object which can be further customized using
tmap commands or exported/saved to multiple image file formats. See
\code{\link[tmap:tmap_save]{tmap::tmap_save()}} for export details.

This function visualizes the outputs from \code{\link[=fire_exp]{fire_exp()}}.
The map can be returned with a continuous scale or can be classified.

Classes can be chosen from the pre-set \code{"local"} and \code{"landscape"} options,
or customized. To use a custom classification scheme, it should be defined
with a list of numeric vectors defining the upper limits of the breaks. A
Nil class is added automatically for exposure values of exactly zero.

Local classification breaks are predefined as \code{c(0.15, 0.3, 0.45, 1)}:
\itemize{
\item Nil (0)
\item 0 - 0.15
\item 0.15 - 0.3
\item 0.3 - 0.45
\item 0.45 - 1
}

Landscape classification breaks are predefined as \code{c(0.2, 0.4, 0.6, 0.8, 1)}:
\itemize{
\item Nil (0)
\item 0 - 0.2
\item 0.2 - 0.4
\item 0.4 - 0.6
\item 0.6 - 0.8
\item 0.8 - 1
}
\subsection{Spatial reference}{

This function dynamically pulls map tiles for a base map. The crs is set
automatically. See \code{\link[tmap:tm_crs]{tmap::tm_crs()}} for details.
}
}
\examples{
# read example hazard data
hazard_file_path <- "extdata/hazard.tif"
hazard <- terra::rast(system.file(hazard_file_path, package = "fireexposuR"))


# compute exposure
exposure <- fire_exp(hazard)


fire_exp_map(exposure)

}
