% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_exp_dir_map.R
\name{fire_exp_dir_map}
\alias{fire_exp_dir_map}
\title{Map directional exposure}
\usage{
fire_exp_dir_map(transects, value, labels, title = "Directional Vulnerability")
}
\arguments{
\item{transects}{SpatVector. Output from \code{\link[=fire_exp_dir]{fire_exp_dir()}}}

\item{value}{(Optional) SpatVector. Adds the value to the map. Use the same
value feature used to generate the transects with \code{\link[=fire_exp_dir]{fire_exp_dir()}}}

\item{labels}{(Optional) a vector of three strings. Custom formatting for the
distances in the legend. If left blank, the function will automatically label
the distances in meters.}

\item{title}{(Optional) String. A custom title for the plot. The default is
\code{"Directional Vulnerability"}}
}
\value{
a map of directional exposure transects as a tmap object
}
\description{
\code{fire_exp_dir_map()} plots directional exposure transects onto
a map.
}
\details{
This function returns a standardized map with basic cartographic elements.

The plot is returned as a tmap object which can be further customized using
tmap commands or exported/saved to multiple image file formats. See
\code{\link[tmap:tmap_save]{tmap::tmap_save()}} for export details.
\subsection{Spatial reference}{

This function dynamically pulls map tiles for a base map. The crs is set
automatically. See \code{\link[tmap:tm_crs]{tmap::tm_crs()}} for details.
}
}
\examples{

\donttest{
# read example hazard data
hazard_file_path <- "extdata/hazard.tif"
hazard <- terra::rast(system.file(hazard_file_path, package = "fireexposuR"))

# generate an example point
point_wkt <- "POINT (345000 5876000)"
point <- terra::vect(point_wkt, crs = hazard)

# compute exposure metric
exposure <- fire_exp(hazard)

# generate transects
transects <- fire_exp_dir(exposure, point, interval = 5)

fire_exp_dir_map(transects)
}
}
