% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_init.R
\name{flash_init}
\alias{flash_init}
\title{Initialize flash object}
\usage{
flash_init(data, S = NULL, var_type = 0L, S_dim = NULL)
}
\arguments{
\item{data}{The observations. Usually a matrix, but can also be a sparse
matrix of class \code{\link[Matrix]{Matrix}} or a low-rank matrix
representation as returned by, for example, \code{\link{svd}},
\code{\link[irlba]{irlba}}, \code{\link[rsvd]{rsvd}}, or
\code{\link[softImpute]{softImpute}} (in general, any list that
includes fields \code{u}, \code{d}, and \code{v} will be interpreted
as a low-rank matrix representation).}

\item{S}{The standard errors. Can be \code{NULL} (in which case all residual
variance will be estimated) or a matrix, vector, or scalar. \code{S}
should be a scalar if standard errors are identical across observations. It
should be a vector if standard errors either vary across columns but are
constant within any given row, or vary across rows but are constant within
any given column (\code{flash} will use the length of the vector
to determine whether the supplied values correspond to rows or columns; if the
data matrix is square, then the sense must be specified using parameter
\code{S_dim} in function \code{\link{flash_init}}).}

\item{var_type}{Describes the structure of the estimated residual variance.
  Can be \code{NULL}, \code{0}, \code{1}, \code{2}, or \code{c(1, 2)}. If
  \code{NULL}, then \code{S} accounts for all residual variance. If
  \code{var_type = 0}, then the estimated residual variance (which is added
  to any variance given by \code{S}) is assumed to be constant
  across all observations. Setting \code{var_type = 1} estimates a single
  variance parameter for each row; \code{var_type = 2} estimates one
  parameter for each column; and \code{var_type = c(1, 2)} optimizes over
  all rank-one matrices (that is, it assumes that the residual variance
  parameter \eqn{s_{ij}} can be written \eqn{s_{ij} = a_i b_j}, where the
  \eqn{n}-vector \eqn{a} and the \eqn{p}-vector \eqn{b} are to be
  estimated).

  Note that if any portion of the residual variance is to be estimated, then
  it is usually faster to set \code{S = NULL} and to let \code{flash}
  estimate all of the residual variance. Further, \code{var_type = c(1, 2)}
  is typically much slower than other options, so it should be used with
  care.}

\item{S_dim}{If the argument to \code{S} is a vector and the data matrix is
square, then \code{S_dim} must specify whether \code{S} encodes row-wise or
column-wise standard errors. More precisely,
if \code{S_dim = 1}, then \code{S} will be interpreted as giving
standard errors that vary across rows but are constant within any particular
row; if \code{S_dim = 2}, then it will be interpreted as giving
standard errors that vary across columns but are constant within any
particular column. If \code{S} is a matrix or scalar, or if the data
matrix is not square, then \code{S_dim} should be left unspecified
(\code{NULL}).}
}
\value{
An initialized \code{\link{flash}} object (with no factors).
}
\description{
Sets up a \code{\link{flash}} object with no factors. Since all other
\code{flash_xxx} functions take a \code{flash} or \code{flash_fit} object
as their first argument, calling \code{flash_init} should be the first step
in any \code{flash} pipeline. See \code{\link{flash}} for examples of usage.
}
