% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_svg_annotator_data.R
\name{bind_svg_annotator_data}
\alias{bind_svg_annotator_data}
\title{Bind svg annotator data}
\usage{
bind_svg_annotator_data(
  .,
  data = NULL,
  id = NULL,
  reveal_id = NULL,
  h1 = NULL,
  h2 = NULL,
  content = NULL,
  link = NULL,
  metadata = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{id}{ID. A column of IDs of elements in the uploaded SVG file. Flourish type hint: column}

\item{reveal_id}{Reveal layer. A column to reveal when layer is clicked. Flourish type hint: column}

\item{h1}{Heading 1. A column containing the main header. Flourish type hint: column}

\item{h2}{Heading 2. A column containing a secondary header. Flourish type hint: column}

\item{content}{Content. A column containing text or HTML to display. Flourish type hint: column}

\item{link}{Link. A URL that can be opened when a layer is clicked. Any reveal layers or popups will be overridden. Flourish type hint: column}

\item{metadata}{Info for popups. One or more columns to display in popups and panels. Flourish type hint: columns}
}
\value{
A Flourish chart
}
\description{
Bind svg annotator data
}
\examples{
try(
  flourish(chart_type = "svg_annotator", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_svg_annotator_data(gapminder)
)
}
