% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_example.R
\name{get_example}
\alias{get_example}
\title{Create example data}
\usage{
get_example(
  example = c("MaxQuant", "DIA-NN", "Spectronaut", "PD", "RetentionTime")
)
}
\arguments{
\item{example}{Choose between \code{"ProteomeDiscoverer"}, \code{"Spectronaut"}, \code{"DIA-NN"} and \code{"MaxQuant"} or for an example for downstream analysis \code{"RetentionTime"}. Default is MaxQuant.}
}
\value{
This function returns example data as dataframe for the respective chosen \code{example}. For \code{"MaxQuant"} a list with evidence/proteingroup dataframe. For \code{"RetentionTime"} a list with Spectronaut/DIA-NN data including retention time information.
}
\description{
Example data for ProteomeDiscoverer, Spectronaut, DIA-NN and MaxQuant.
}
\details{
Data for each software for testing functions of flowTraceR. Additional example data for Spectronaut and DIA-NN for analyzing retention time distribution on precursor level.
}
\examples{

# Spectronaut example data
Spectronaut_data <- get_example(example = "Spectronaut")
}
\author{
Oliver Kardell
}
