% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluspect.R
\name{fluspect}
\alias{fluspect}
\title{fluspect}
\usage{
fluspect(leafbio, spectral = define.bands(), optipar = NULL)
}
\arguments{
\item{leafbio}{Data Frame. It contains: Cab, Cca, Cw, Cdm, Cs, N, fqe}

\item{spectral}{List. (Optional) A spectral object created with \link{define.bands}. A default spectral object is used
if the user does not indicate any.}

\item{optipar}{Data Frame. (Optional) It contains: nr, Kdm, Kab, Kca, Kw, Ks, phiI, phiII. A default optipar object is used
if the user does not indicate any.}
}
\value{
a list which contains:
\itemize{
\item refl (reflectance)
\item tran (transmittance)
\item Mb (backward scattering fluorescence matrix, I for PSI and II for PSII)
\item Mf (forward scattering fluorescence matrix,  I for PSI and II for PSII)
}
}
\description{
\code{fluspect} calculates reflectance and transmittance spectra of a leaf using FLUSPECT-B,
plus four excitation-fluorescence matrices
}
\details{
More information: \href{https://doi.org/10.1016/j.rse.2016.09.017}{Fluspect-B: A model for leaf fluorescence, reflectance and transmittance spectra. Vilfan et al., 2016}\cr\cr
Original version in MatLab: \href{https://github.com/Christiaanvandertol/Fluspect}{github.com/Christiaanvandertol/Fluspect}
}
\examples{
leafbio <- data.frame(Cab = 70, Cca = 30, Cw = 0.013, Cdm = 0.024, Cs = 0.0, N = 4.09, fqe = 0.02)
leafopt <- fluspect(leafbio)
plot(leafopt$refl)

}
\author{
Nastassia Vilfan, Christiaan van der Tol, Onno Muller, Uwe Rascher, Wouter Verhoef (Original version in Matlab)

Alberto Hornero (Ported version into R)
}
