% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_inv_logit}
\alias{hrf_inv_logit}
\title{hrf_inv_logit}
\usage{
hrf_inv_logit(t, mu1 = 6, s1 = 1, mu2 = 16, s2 = 1, lag = 0)
}
\arguments{
\item{t}{A vector of times.}

\item{mu1}{The time-to-peak for the rising phase (mean of the first logistic function).}

\item{s1}{The width (slope) of the first logistic function.}

\item{mu2}{The time-to-peak for the falling phase (mean of the second logistic function).}

\item{s2}{The width (slope) of the second logistic function.}

\item{lag}{The time delay (default: 0).}
}
\value{
A vector of the difference of two Inverse Logit HRF values.
}
\description{
A hemodynamic response function using the difference of two Inverse Logit functions.
}
\examples{
hrf_inv_logit_basis <- hrf_inv_logit(seq(0, 20, by = 0.5), mu1 = 6, s1 = 1, mu2 = 16, s2 = 1)
}
\seealso{
Other hrf_functions: 
\code{\link{hrf_basis_lwu}()},
\code{\link{hrf_bspline}()},
\code{\link{hrf_gamma}()},
\code{\link{hrf_gaussian}()},
\code{\link{hrf_lwu}()},
\code{\link{hrf_mexhat}()},
\code{\link{hrf_sine}()},
\code{\link{hrf_spmg1}()},
\code{\link{hrf_time}()}
}
\concept{hrf_functions}
