% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf_decorators.R
\name{lag_hrf}
\alias{lag_hrf}
\title{Lag an HRF Object}
\usage{
lag_hrf(hrf, lag)
}
\arguments{
\item{hrf}{The HRF object (of class `HRF`) to lag.}

\item{lag}{The time lag in seconds to apply. Positive values shift the response later in time.}
}
\value{
A new HRF object representing the lagged function.
}
\description{
Creates a new HRF object by applying a temporal lag to an existing HRF object.
}
\examples{
lagged_spmg1 <- lag_hrf(HRF_SPMG1, 5)
# Evaluate at time 10; equivalent to HRF_SPMG1(10 - 5)
lagged_spmg1(10)
HRF_SPMG1(5)
}
\seealso{
Other HRF_decorator_functions: 
\code{\link{block_hrf}()},
\code{\link{normalise_hrf}()}
}
\concept{HRF_decorator_functions}
