% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R,
%   R/reconstruction_matrix-methods.R
\name{reconstruction_matrix}
\alias{reconstruction_matrix}
\alias{reconstruction_matrix.HRF}
\title{Combine HRF Basis with Coefficients}
\usage{
reconstruction_matrix(hrf, sframe, ...)

\method{reconstruction_matrix}{HRF}(hrf, sframe, ...)
}
\arguments{
\item{hrf}{An object of class `HRF`.}

\item{sframe}{A numeric vector of times, or a `sampling_frame` object from which
times are extracted via `samples()`.}

\item{...}{Additional arguments passed to `samples()` when `sframe` is a
`sampling_frame`, and to `evaluate()` for HRF evaluation.}
}
\value{
A numeric matrix with one column per basis function.

A numeric matrix of dimension `length(times) x nbasis(hrf)`.
}
\description{
Create a new HRF by linearly weighting the basis functions of an existing HRF.
This is useful for turning estimated basis coefficients into a single
functional HRF.

S3 method for `HRF` objects that returns a matrix mapping basis coefficients
to sampled HRF values at the provided time grid. For single-basis HRFs, this
returns a one-column matrix. For multi-basis HRFs (e.g., SPMG2/SPMG3, FIR,
B-spline), this returns a matrix with one column per basis function.
}
\details{
Reconstruction matrix for an HRF basis

Returns a matrix \eqn{\Phi} that converts basis coefficients into a
sampled HRF shape.
}
\examples{
# Create reconstruction matrix for basis functions
hrf <- HRF_SPMG2  # 2-basis HRF
times <- seq(0, 20, by = 0.5)
rmat <- reconstruction_matrix(hrf, times)
dim(rmat)  # Shows dimensions
}
