% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_mexhat}
\alias{hrf_mexhat}
\title{Mexican Hat HRF (hemodynamic response function)}
\usage{
hrf_mexhat(t, mean = 6, sd = 2)
}
\arguments{
\item{t}{A vector of time points.}

\item{mean}{A numeric value representing the mean of the Mexican hat wavelet. Default value is 6.}

\item{sd}{A numeric value representing the standard deviation of the Mexican hat wavelet. Default value is 2.}
}
\value{
A numeric vector representing the Mexican hat wavelet-based HRF at the given time points `t`.
}
\description{
The `hrf_mexhat` function computes the Mexican hat wavelet-based HRF (hemodynamic response function) at given time points `t`.
}
\examples{
# Compute the Mexican hat HRF representation for time points from 0 to 20 with 0.5 increments
hrf_mexhat_vals <- hrf_mexhat(seq(0, 20, by = .5), mean = 6, sd = 2)
}
\seealso{
Other hrf_functions: 
\code{\link{hrf_basis_lwu}()},
\code{\link{hrf_boxcar}()},
\code{\link{hrf_bspline}()},
\code{\link{hrf_gamma}()},
\code{\link{hrf_gaussian}()},
\code{\link{hrf_inv_logit}()},
\code{\link{hrf_lwu}()},
\code{\link{hrf_sine}()},
\code{\link{hrf_spmg1}()},
\code{\link{hrf_time}()},
\code{\link{hrf_weighted}()}
}
\concept{hrf_functions}
