% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gradient0}
\alias{gradient0}
\title{Numerical Gradient Vector}
\usage{
gradient0(f, x, args)
}
\arguments{
\item{f}{Function to differentiate.}

\item{x}{Vector at which to evaluate the gradient.}

\item{args}{List of additional arguments from the function \code{richardson_args}.}
}
\value{
A list with the form of a \code{gradient_result} described in section "Gradient"
of the package vignette.
}
\description{
Numerical Gradient Vector
}
\examples{
f = function(x) { sum(sin(x)) }
args = richardson_args()
x0 = seq(0, 1, length.out = 5)
cos(x0)  ## Exact answer
gradient0(f, x0, args)
numDeriv::grad(f, x0)

}
