% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\docType{data}
\name{loire}
\alias{loire}
\title{Medieval Ceramics from the Loire Basin}
\format{
A \code{data.frame} with 332 observations (assemblages) and 331 variables (ceramic types).
The first five columns provide background information, the next columns give
the MNI of each ceramic types:
\describe{
\item{site}{\code{\link{character}}: name of the archaeological site.}
\item{city}{\code{\link{character}}: city.}
\item{area}{\code{\link{character}}: geographical area.}
\item{lower}{\code{\link{integer}}: lower bound of the temporal range (year AD).}
\item{upper}{\code{\link{integer}}: upper bound of the temporal range (year AD).}
}
}
\source{
https://ceramedvaldeloire.huma-num.fr/editions/suppl79racf2022/accueil
}
\usage{
loire
}
\description{
A dataset containing the ceramic counts from the Loire Basin (France).
}
\references{
Husi, P. (dir.). (2022). \emph{La céramique médiévale et moderne du bassin de la
Loire moyenne, chrono-typologie et transformation des aires culturelles
dans la longue durée (6e-19e s.)}. Suppléments à la revue Archéologique du
Centre de la France, 79.
}
\seealso{
Other count data: 
\code{\link{birds}},
\code{\link{boves}},
\code{\link{chevelon}},
\code{\link{compiegne}},
\code{\link{merzbach}},
\code{\link{mississippi}},
\code{\link{zuni}}
}
\concept{count data}
\keyword{datasets}
