% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navbarPage.R
\name{navbar_menu}
\alias{navbar_menu}
\title{Navbar Menu}
\usage{
navbar_menu(title, ..., id = title, icon = NULL)
}
\arguments{
\item{title}{Display title for menu}

\item{...}{\code{\link{tab_panel}} elements to include in the page. Can also include strings as section headers,
or "----" as a horizontal separator.}

\item{id}{The ID of the \code{navbar_menu}}

\item{icon}{Optional icon to appear on the tab.
This attribute is only valid when using a \code{tab_panel} within a \code{\link{navbar_page}}.}
}
\value{
A structured list of class \code{ssnavmenu}, that can be used in \code{\link{navbar_page}}.
}
\description{
Create a dropdown menu for a \code{\link{navbar_page}}.
}
\examples{
navbar_menu(
  "Menu",
  tab_panel("Summary", shiny::plotOutput("plot")),
  "----",
  "Section header",
  tab_panel("Table", shiny::tableOutput("table"))
)

}
