% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foot_round_robin.R
\name{foot_round_robin}
\alias{foot_round_robin}
\title{Round-robin for football leagues}
\usage{
foot_round_robin(object, data, teams = NULL, output = "both")
}
\arguments{
\item{object}{An object either of class \code{stanFoot}, \code{CmdStanFit}, \code{stanfit}.}

\item{data}{A data frame containing match data with columns:
\itemize{
  \item \code{periods}:  Time point of each observation (integer >= 1).
  \item \code{home_team}: Home team's name (character string).
  \item \code{away_team}: Away team's name (character string).
  \item \code{home_goals}: Goals scored by the home team (integer >= 0).
  \item \code{away_goals}: Goals scored by the away team (integer >= 0).
}}

\item{teams}{An optional character vector specifying team names to include. If \code{NULL}, all teams are included.}

\item{output}{An optional character string specifying the type of output to return. One of \code{"both"}, \code{"table"},
or \code{"plot"}. Default is \code{"both"}.}
}
\value{
If \code{output = "both"} a list with:
\itemize{
  \item{\code{round_table}}: A data frame of matchups (\code{Home}, \code{Away}), observed scores, and \code{Home_prob} (median posterior probability of a home win).
  \item{\code{round_plot}}: A \code{ggplot} heatmap of home‑win probabilities with observed scores overlaid.
}
If \code{output = "table"} or \code{"plot"}, returns only that component.
}
\description{
Posterior predictive probabilities for a football season in a round-robin format
}
\details{
For Bayesian models fitted via \code{stan_foot} the round-robin table is computed according to the
simulation from the posterior predictive distribution of future (out-of-sample) matches.
The dataset should refer to one or more seasons from a given national football league (Premier League, Serie A, La Liga, etc.).
}
\examples{
\dontrun{
if (instantiate::stan_cmdstan_exists()) {
  library(dplyr)

  data("italy")
  italy_1999_2000 <- italy \%>\%
    dplyr::select(Season, home, visitor, hgoal, vgoal) \%>\%
    dplyr::filter(Season == "1999" | Season == "2000")

  colnames(italy_1999_2000) <- c("periods", "home_team", "away_team", "home_goals", "away_goals")

  fit <- stan_foot(italy_1999_2000, "double_pois", predict = 45, iter_sampling = 200)

  foot_round_robin(fit, italy_1999_2000)
  foot_round_robin(fit, italy_1999_2000, c("Parma AC", "AS Roma"))
}
}
}
\author{
Leonardo Egidi \email{legidi@units.it} and Roberto Macrì Demartino \email{roberto.macridemartino@deams.units.it}
}
