% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_year.R
\name{filter_by_year}
\alias{filter_by_year}
\title{Filter FORCIS data by year of sampling}
\usage{
filter_by_year(data, years)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}

\item{years}{a \code{numeric} containing one or several years.}
}
\value{
A \code{tibble} containing a subset of \code{data} for the desired years.
}
\description{
Filters FORCIS data by year of sampling.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Dimensions of the data.frame ----
dim(net_data)

# Filter by years ----
net_data_sub <- filter_by_year(net_data, years = 1992)

# Dimensions of the data.frame ----
dim(net_data_sub)
}
