% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degraded_forest_preprocess.R
\name{degraded_forest_preprocess}
\alias{degraded_forest_preprocess}
\title{Preprocess the degraded forest data}
\usage{
degraded_forest_preprocess(tree_1, tree_2, tree_3, plot_1, plot_2, plot_3)
}
\arguments{
\item{tree_1}{Tree data for the 1st period}

\item{tree_2}{Tree data for the 2nd period}

\item{tree_3}{Tree data for the 3rd period}

\item{plot_1}{Sample plot data for the 1st period}

\item{plot_2}{Sample plot data for the 2nd period}

\item{plot_3}{Sample plot data for the 3rd period}
}
\value{
Preprocessed plot_data
}
\description{
Preprocess the degraded forest data and return the plot_data.
}
\details{
tree_1, tree_2, tree_3 are required to include the fields "plot_id", "inspection_type", and "tree_species_code". plot_1, plot_2, and plot_3 are required to include the fields "plot_id", "standing_stock", "forest_cutting_stock", "crown_density", "disaster_level", "origin", "dominant_tree_species", "age_group", "naturalness", and "land_type".
}
\examples{
\donttest{
# Load forest survey data
data(tree_1)
data(tree_2)
data(tree_3)
data(plot_1)
data(plot_2)
data(plot_3)

# Preprocess the degraded forest data
plot_data <- degraded_forest_preprocess(tree_1,tree_2,tree_3,plot_1,plot_2,plot_3)
}
}
