% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_forest_plot.R
\name{panel_forest_plot}
\alias{panel_forest_plot}
\title{Plot a forest plot with panels of text}
\usage{
panel_forest_plot(
  forest_data,
  mapping = aes(estimate, xmin = conf.low, xmax = conf.high),
  panels = default_forest_panels(),
  trans = I,
  funcs = NULL,
  format_options = list(colour = "black", shape = 15, banded = TRUE, text_size = 5,
    point_size = 5),
  theme = theme_forest(),
  limits = NULL,
  breaks = NULL,
  recalculate_width = TRUE,
  recalculate_height = TRUE,
  exclude_infinite_cis = TRUE
)
}
\arguments{
\item{forest_data}{\code{data.frame} with the data needed for both the plot and text}

\item{mapping}{mapping aesthetic created using \code{\link[ggplot2]{aes}}}

\item{panels}{\code{list} with details of the panels that make up the plot (See Details)}

\item{trans}{transform for scales}

\item{funcs}{optional list of functions required for formatting \code{panels$display}}

\item{format_options}{formatting options as a list as generated by \code{\link{forest_model_format_options}}}

\item{theme}{theme to apply to the plot}

\item{limits}{limits of the forest plot on the X-axis (taken as the range of the data
by default)}

\item{breaks}{breaks to appear on the X-axis (note these will be exponentiated
if \code{exponentiate == TRUE})}

\item{recalculate_width}{\code{TRUE} to recalculate panel widths using the current device
or the desired plot width in inches}

\item{recalculate_height}{\code{TRUE} to shrink text size using the current device
or the desired plot height in inches}

\item{exclude_infinite_cis}{whether to exclude points and confidence intervals
that go to positive or negative infinity from plotting. They will still be
displayed as text. Defaults to \code{TRUE}, since otherwise plot is malformed}
}
\value{
A ggplot ready for display or saving
}
\description{
Plot a forest plot with panels of text
}
