% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substituting_formula.R
\name{substituting_formula}
\alias{substituting_formula}
\alias{as_substituting_formula}
\title{A substituting formula helps clarify a formula where the parameters are more
simply described in separate formulae.}
\usage{
substituting_formula(x, ...)

as_substituting_formula(x, substitutions)
}
\arguments{
\item{x}{The base formula}

\item{...}{Supporting formula of the form \code{x1~x2+x3*x4...}}

\item{substitutions}{A list of supporting formula.}
}
\value{
A \code{substituting_formula} object which may be coerced into a
  single formula with an \code{as.formula()} method or printed as a list of
  formulae.
}
\description{
A substituting formula helps clarify a formula where the parameters are more
simply described in separate formulae.
}
\details{
Formula are substituted in order.  Substitutions may not have the
  same left hand side.
}
\section{Functions}{
\itemize{
\item \code{as_substituting_formula()}: Generate and check substituting_formula

}}
\examples{
foo <- substituting_formula(y~x1+x2, x1~x3*x4, x2~x5/x6+x7)
as.formula(foo)
}
