% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdLoglik.R
\name{ibdLoglik}
\alias{ibdLoglik}
\alias{ibdLoglikFUN}
\title{Pairwise IBD likelihood}
\usage{
ibdLoglik(x = NULL, ids = NULL, kappa = NULL, delta = NULL)

ibdLoglikFUN(x, ids, input = c("kappa", "kappa02", "delta"))
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{ids}{A vector of ID labels.}

\item{kappa}{A probability vector of length 3.}

\item{delta}{A probability vector of length 9.}

\item{input}{Either "kappa", "kappa02" or "delta". See Value.}
}
\value{
\code{ibdLoglik()} returns a single number; the total log-likelihood over
all markers included.

\code{ibdLoglikFUN()} returns a function for computing such log-likelihoods. The
function takes a single input vector \code{p}, whose interpretation depends on
the \code{input} parameter:
\itemize{
\item "kappa": \code{p} is expected to be a set of kappa coefficients
\eqn{(\kappa_0, \kappa_1, \kappa_2)}.
\item "kappa02": \code{p} should be a vector of length 2 containing the coefficients
\eqn{\kappa_0} and \eqn{\kappa_2}. This is sometimes a convenient shortcut
when working in the IBD triangle.
\item "delta": Expects \code{p} to be a set of condensed Jacquard coefficients
\eqn{(\Delta_1, ..., \Delta_9)}.
}
}
\description{
Given genotype data from two individuals, computes the log-likelihood of a
single set of IBD coefficients, either  \code{kappa} = \eqn{(\kappa_0, \kappa_1,
\kappa_2)} or the Jacquard coefficients \code{delta} = \eqn{(\Delta_1, ..., \Delta_9)}.
The \code{ibdLoglikFUN} version returns an efficient \emph{function} for computing such
likelihoods, suitable for optimisations such as in \code{\link[=ibdEstimate]{ibdEstimate()}}.
}
\examples{
# Siblings typed with 10 markers
x = nuclearPed(2) |> markerSim(N = 10, alleles = 1:4)

# Calculate log-likelihood at a single point
k = c(0.25, 0.5, 0.25)
ibdLoglik(x, ids = 3:4, kappa = k)

# Or first get a function, and then apply it
llFun = ibdLoglikFUN(x, ids = 3:4, input = "kappa")
llFun(k)


}
