% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpaccess.R
\name{Fpsn}
\alias{Fpsn}
\title{Fpsn}
\usage{
Fpsn(x, Kmax, mini = min(x), maxi = max(x))
}
\arguments{
\item{x}{a numerical vector to segment}

\item{Kmax}{max number of segments (segmentations in 1 to Kmax segments are recovered).}

\item{mini}{minimum mean segment value to consider in the optimisation}

\item{maxi}{maximum mean segment value to consider in the optimisation}
}
\value{
return a list with a matrix t.est containing the change-points of the segmentations in 1 to Kmax changes and, the cost J.est in 1 to Kmax changes.
}
\description{
Function to run the pDPA algorithm (Rigaill 2010 and 2015). It uses functional pruning and segment neighborhood. It optimizes the L2-loss for 1 to Kmax changes.
}
\examples{
x <- c(rnorm(100), rnorm(10^3)+2, rnorm(1000)+1)
res <- Fpsn(x=x, K=100)
select.res <- select_Fpsn(res, method="givenVariance")
smt <- getSMT(res, select.res)
}
