% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{wbw}
\alias{wbw}
\title{Function to select the bandwidth parameter needed for smoothing the time-dependent ROC curve.}
\usage{
wbw(X, wt, bw = "NR", ktype = "normal")
}
\arguments{
\item{X}{numeric data vector.}

\item{wt}{non-negative weight vector.}

\item{bw}{a character string specifying the bandwidth selection method. The possible options are "\code{NR}" for the normal reference, the plug-in "\code{PI}" and cross-validation "\code{CV}".}

\item{ktype}{a  character string indicating the type of kernel function: "\code{normal}", "\code{epanechnikov}", "\code{biweight}", or "\code{triweight}". Default is "\code{normal}" kernel.}
}
\value{
Returns the estimated value for the bandwidth parameter.
}
\description{
{This function computes a data-driven bandwidth for smoothing the ROC curve, supporting
             three methods: the normal reference method, the plug-in method, and the cross-validation
             method introduced in Beyene and El Ghouch (2020). It is particularly important for
             estimating the bandwidth in the presence of weighted data.}
}
\examples{
library(frailtyROC)

X <- rnorm(100) # random data vector
wt <- runif(100) # weight vector

# Normal reference bandwidth selection

wbw(X = X, wt = wt)$bw

}
\references{
Beyene, K.M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}. 39: 3373-3396.
}
