% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/franc.R
\encoding{utf8}
\name{franc_all}
\alias{franc_all}
\title{List of probably languages for a text}
\usage{
franc_all(text, min_speakers = 1e+06, whitelist = NULL,
  blacklist = NULL, min_length = 10, max_length = 2048)
}
\arguments{
\item{text}{A string constant. Should be at least \code{min_length}
characters long, this is 10 chracters by default.
Only the first \code{max_length} characters are used (2048 by
default), to make the detection reasonably fast.}

\item{min_speakers}{Languages with at least this many speakers are
checked. By default this is one million. Set it to zero to
include all languages known by franc. See also \code{\link{speakers}}.}

\item{whitelist}{List of three letter language codes to check against.}

\item{blacklist}{List of three letter language codes not to check
againts.}

\item{min_length}{Minimum number of characters required in the text.}

\item{max_length}{Maximum number of characters used from the text.
By default only the first 2048 characters are used.}
}
\value{
A data frame with columns \code{language} and \code{score}.
  The \code{language} column contains the three letter ISO-639-3
  language codes. The \code{score} column contains the scores.
}
\description{
Returns the scores for all languages that use the same script
as the input text, in decreasing order of probability. The score
is calculated from the distances of the trigram distributions
in the input text and in the language model. The closer the languages,
the higher the score. Scores are scaled, so that the closest language
will have a score of 1.
}
\examples{
head(franc_all("O Brasil caiu 26 posições"))

## Provide a whitelist:
franc_all("O Brasil caiu 26 posições",
  whitelist = c("por", "src", "glg", "spa"))

## Provide a blacklist:
head(franc_all("O Brasil caiu 26 posições",
  blacklist = c("src", "glg", "lav")))
}
\seealso{
\code{\link{franc}} if you only want the top result,
  \code{\link{speakers}}.
}
