% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.denReg.R
\name{plot.denReg}
\alias{plot.denReg}
\title{Plots for Fréchet regression for univariate densities.}
\usage{
\method{plot}{denReg}(
  x,
  obj = NULL,
  prob = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  ylim = NULL,
  xlim = NULL,
  col.bar = TRUE,
  widrt = 4,
  col.lab = NULL,
  nticks = 5,
  ticks = NULL,
  add = FALSE,
  pos.prob = 0.9,
  colPalette = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{denReg} object, result of \code{\link{DenFMean}}, \code{\link{GloDenReg}} or \code{\link{LocDenReg}}.}

\item{obj}{An integer indicating which output to be plotted; 1, 2, 3, 4, and 5 for \code{dout}, \code{qout}, \code{din}, \code{qin}, and reference chart for \code{qout}, respectively - default: 1.}

\item{prob}{A vector specifying the probability levels for reference chart if \code{obj} is set to 5. Default: \code{c(0.05,0.25,0.5,0.75,0.95)}.}

\item{xlab}{Character holding the label for x-axis; default: \code{"Probability"} when \code{obj} is 2 or 4, \code{""} when \code{obj} is 1 or 3, \code{"x"} when \code{obj} is 5.}

\item{ylab}{Character holding the label for y-axis; default: \code{"Quantile"} when \code{obj} is 2, 4, or 5, and \code{"Density"} when \code{obj} is 1 or 3.}

\item{main}{Character holding the plot title; default: \code{NULL}.}

\item{ylim}{A numeric vector of length 2 holding the range of the y-axis to be drawn; default: automatically determined by the input \code{x}.}

\item{xlim}{A numeric vector of length 2 holding the range of the x-axis to be drawn; default: automatically determined by the input \code{x}.}

\item{col.bar}{A logical variable indicating whether a color bar is presented on the right of the plot - default: \code{TRUE}.}

\item{widrt}{A scalar giving the width ratio between the main plot and the color bar - default: 4.}

\item{col.lab}{A character giving the color bar label.}

\item{nticks}{An integer giving the number of ticks used in the axis of color bar.}

\item{ticks}{A numeric vector giving the locations of ticks used in the axis of color bar; it overrides \code{nticks}.}

\item{add}{Logical; only works when \code{obj} is 5. If \code{TRUE} add to an already existing plot. Taken as \code{FALSE} (with a warning if a different value is supplied) if no graphics device is open.}

\item{pos.prob}{\code{FALSE} or a scalar less than 0 or larger than 1. FALSE: no probability levels will be labeled on the quantile curves; a scalar between 0 and 1: indicating where to put the probability levels along the curves on growth charts: 0 and 1 correspond to left and right ends, respectively. Default: 0.9.}

\item{colPalette}{A function that takes an integer argument (the required number of colors) and returns a character vector of colors interpolating the given sequence
(e.g., \code{\link{heat.colors}}, \code{\link{terrain.colors}} and functions created by \code{\link{colorRampPalette}}).
Default is \code{colorRampPalette(colors = c("pink","royalblue"))} for more than one curves and \code{"black"} otherwise.}

\item{...}{Can set up \code{lty}, \code{lwd}, etc.}
}
\value{
No return value.
}
\description{
Plots for Fréchet regression for univariate densities.
}
\note{
see \code{\link{DenFMean}}, \code{\link{GloDenReg}} and \code{\link{LocDenReg}} for example code.
}
