% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_curv.R
\name{write.fs.morph.ni1}
\alias{write.fs.morph.ni1}
\title{Write morphometry data in NIFTI v1 format.}
\usage{
write.fs.morph.ni1(filepath, data, ...)
}
\arguments{
\item{filepath}{string, the full path of the output NIFTI file. Should end with '.nii' or '.nii.gz'.}

\item{data}{numerical vector, the data to write. Will be coerced to double.}

\item{...}{extra parameters passed to \code{\link{write.nifti1}}.}
}
\value{
format, string. The format that was used to write the data: "ni1".
}
\description{
Write morphometry data in NIFTI v1 format.
}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.ni2}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.weight}()},
\code{\link{write.fs.weight.asc}()}

Other nifti1 writers: 
\code{\link{write.nifti1}()}
}
\concept{morphometry functions}
\concept{nifti1 writers}
