% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hemilist.R
\name{hemilist.from.prefixed.list}
\alias{hemilist.from.prefixed.list}
\title{Create a hemilist from a named list with keys prefixed with 'lh_' and 'rh_'.}
\usage{
hemilist.from.prefixed.list(
  named_list,
  report_ignored = TRUE,
  return_ignored = FALSE
)
}
\arguments{
\item{named_list}{a named list, the keys must start with 'lh_' or 'rh_' to be assigned to the 'lh' and 'rh' entries of the returned hemilist. Other entries will be ignored.}

\item{report_ignored}{logical, whether to print a message with the ignored entries, if any.}

\item{return_ignored}{logical, whether to add a key 'ignored' to the returned hemilist, containing the ignored entries.}
}
\value{
a hemilist
}
\description{
A hemilist is a named list with entries 'lh' and/or 'rh', see \code{\link{hemilist}}.
}
\seealso{
Other hemilist functions: 
\code{\link{hemilist}()},
\code{\link{hemilist.derive.hemi}()},
\code{\link{hemilist.get.combined.data}()},
\code{\link{hemilist.unwrap}()},
\code{\link{hemilist.wrap}()},
\code{\link{is.hemilist}()}
}
\concept{hemilist functions}
