% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fucom.R
\name{fucom_method}
\alias{fucom_method}
\title{Implementation of Full Consistency Method (FUCOM) for multi-criteria decision making.
More information about the method at https://doi.org/10.3390/sym10090393.
More information about the implementation at https://github.com/mateusvanzetta/fucom.
The goal is to determine the weights of criteria such that the deviation from full consistency (DFC) is minimized.}
\usage{
fucom_method(criteria_rank, criteria_priority, DFC_threshold = 0.025)
}
\arguments{
\item{criteria_rank}{A character vector specifying the rank of each criterion.}

\item{criteria_priority}{A numeric vector specifying the priority values of each criterion.}

\item{DFC_threshold}{A numeric value specifying the threshold for the deviation from full consistency (DFC).
It must be a positive number and less than or equal to 0.025. Default is 0.025.}
}
\value{
A list containing:
\describe{
  \item{weights}{A numeric vector of the optimized weights for each criterion, summing to 1.}
  \item{Phi}{A numeric vector of comparative priority (Phi) values.}
  \item{w}{A numeric vector of the condition of mathematical transitivity (w) values.}
  \item{DFC}{The minimum deviation from full consistency (DFC) value.}
}
}
\description{
Implementation of Full Consistency Method (FUCOM) for multi-criteria decision making.
More information about the method at https://doi.org/10.3390/sym10090393.
More information about the implementation at https://github.com/mateusvanzetta/fucom.
The goal is to determine the weights of criteria such that the deviation from full consistency (DFC) is minimized.
}
\examples{
criteria_rank <- c("Criterion 1", "Criterion 2", "Criterion 3",
 "Criterion 4", "Criterion 5", "Criterion 6", "Criterion 7", "Criterion 8")
criteria_priority <- c(1, 1, 1, 2, 4, 4, 4, 4)
results <- fucom_method(criteria_rank, criteria_priority)
results$weights
results$Phi
results$w
results$DFC
}
