% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coscilibrary.R
\name{cosci_is}
\alias{cosci_is}
\title{Rank the p features in an n by p design matrix}
\usage{
cosci_is(dat, min.alpha, small.perturbation = 10^(-6))
}
\arguments{
\item{dat}{n by p data matrix}

\item{min.alpha}{the smallest threshold (typically set to 0)}

\item{small.perturbation}{a small positive number to remove ties. Default value is 10^(-6)}
}
\value{
a p vector of scores
}
\description{
Ranks the p features in an n by p design matrix
where n represents the sample size and p is the number of features.
}
\details{
Uses the univariate merging algorithm \code{\link{bmt}} and produces a score
    for each feature that reflects its relative importance for clustering.
}
\examples{
\donttest{
library(fusionclust)
set.seed(42)
noise<-matrix(rnorm(49000),nrow=1000,ncol=49)
set.seed(42)
signal<-c(rnorm(500,-1.5,1),rnorm(500,1.5,1))
x<-cbind(signal,noise)
scores<- cosci_is(x,0)
}
\dontshow{
library(fusionclust)
set.seed(42)
x<-matrix(rnorm(10,0,1),5,2)
scores<- cosci_is(x,0)
}

}
\references{
\enumerate{
\item  Banerjee, T., Mukherjee, G. and Radchenko P., Feature Screening in
Large Scale Cluster Analysis, Journal of Multivariate Analysis,
Volume 161, 2017, Pages 191-212
\item P. Radchenko, G. Mukherjee, Convex clustering via l1 fusion penalization,
 J. Roy. Statist, Soc. Ser. B (Statistical Methodology) (2017)
 doi:10.1111/rssb.12226.
}
}
\seealso{
\code{\link{bmt}},\code{\link{cosci_is_select}}
}
