% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appender.R
\name{flog.appender}
\alias{flog.appender}
\alias{appender.console}
\alias{appender.file}
\alias{appender.file2}
\alias{appender.tee}
\alias{appender.modulo}
\alias{appender.graylog}
\alias{appender.syslog}
\title{Manage appenders for loggers}
\arguments{
\item{\dots}{Used internally by lambda.r}
}
\description{
Provides functions for adding and removing appenders.
}
\section{Usage}{

# Get the appender for the given logger\cr
flog.appender(name) \%::\% character : Function\cr
flog.appender(name='ROOT')

# Set the appender for the given logger\cr
flog.appender(fn, name='ROOT')

# Print log messages to the console\cr
appender.console()

# Write log messages to a file\cr
appender.file(file)

# Write log messages to a dynamically-named file\cr
appender.file2(format)

# Write log messages to console and a file\cr
appender.tee(file)

# Write log messages to a Graylog2 HTTP GELF endpoint\cr
appender.graylog(server, port)

# Write log message to syslog. Arguments are passed on to \code{\link[rsyslog]{open_syslog}}.\cr
appender.syslog(identifier, ...)

# Special meta appender that prints only when the internal counter mod n = 0\cr
appender.modulo(n, appender=appender.console())
}

\section{Details}{

Appenders do the actual work of writing log messages to some target.
To use an appender in a logger, you must register it to a given logger.
Use \code{flog.appender} to both access and set appenders.

The ROOT logger by default uses \code{appender.console}.

\code{appender.console} is a function that writes to the console.
No additional arguments are necessary when registering the appender 
via flog.appender.

\code{appender.file} writes to a file, so you must pass an additional file
argument to the function. To change the file name, just call
\code{flog.appender(appender.file(file))} again with a new file name.

\code{appender.file2} is similar, but the filename is dynamically
determined at runtime. It may include most of the same tokens as
\code{layout.format} (all except \code{"~m"}, the message
itself). This allows, for instance, having separate logfiles for
each log level.

To use your own appender create a function that takes a single argument,
which represents the log message. You need to pass a function reference to
\code{flog.appender}.

\code{appender.tee} writes to both the console and file.

\code{appender.graylog} writes to a Graylog2 HTTP GELF endpoint.

\code{appender.syslog} writes to the POSIX system logger.

\code{appender.modulo} is a meta appender. It calls \code{appender} every \code{n} times.
}

\section{Value}{

When getting the appender, \code{flog.appender} returns the appender
function.  When setting an appender, \code{flog.appender} has no 
return value.
}

\examples{
\dontrun{
flog.appender(appender.console(), name='my.logger')

# Set an appender to the logger named 'my.package'. Any log operations from
# this package will now use this appender.
flog.appender(appender.file('my.package.out'), 'my.package')

# Set an appender to a file named using the message level and calling function.
# Also tee the messages to the console.
flog.appender(appender.file2('~l-~f.log', console = TRUE))
}
}
\seealso{
\code{\link{flog.logger}} \code{\link{flog.layout}}
}
\author{
Brian Lee Yung Rowe
}
\keyword{data}
