% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiraiMultisessionFutureBackend-class.R
\name{mirai_multisession}
\alias{mirai_multisession}
\title{Mirai-based localhost multisession futures}
\usage{
mirai_multisession(..., workers = availableCores(), envir = parent.frame())
}
\arguments{
\item{workers}{The number of parallel processes to use.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
If \code{workers == 1}, then all processing using done in the
current/main \R session and we therefore fall back to using a
sequential future. To override this fallback, use \code{workers = I(1)}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{\ldots}{Not used.}
}
\value{
Nothing.
}
\description{
\emph{WARNING: This function must never be called.
It may only be used with \code{\link[future:plan]{future::plan()}}}
}
\examples{
plan(mirai_multisession)

# A function that returns a future
# (note that N is a global variable)
f <- function() future({
  4 * sum((runif(N) ^ 2 + runif(N) ^ 2) < 1) / N
}, seed = TRUE)

# Run a simple sampling approximation of pi in parallel using  M * N points:
N <- 1e6  # samples per worker
M <- 10   # iterations
pi_est <- Reduce(sum, Map(value, replicate(M, f()))) / M
print(pi_est)

## Switch back to sequential processing, which also
## shuts down the automatically launched mirai workers 
plan(sequential)
}
