% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNDSet2D}
\alias{plotNDSet2D}
\title{Create a plot of a discrete non-dominated set.}
\usage{
plotNDSet2D(
  points,
  crit,
  addTriangles = FALSE,
  addHull = TRUE,
  latex = FALSE,
  labels = NULL
)
}
\arguments{
\item{points}{Data frame with non-dominated points.}

\item{crit}{Either max or min (only used if add the iso-profit line). A vector is currently not
supported.}

\item{addTriangles}{Add search triangles defined by the non-dominated extreme points.}

\item{addHull}{Add the convex hull and the rays.}

\item{latex}{If true make latex math labels for TikZ.}

\item{labels}{If \code{NULL} don't add any labels. If 'n' no labels but show the points. If equal
\code{coord} add coordinates to the points. Otherwise number all points from one.}
}
\value{
The \code{ggplot} object.
}
\description{
Create a plot of a discrete non-dominated set.
}
\note{
Currently only points are checked for dominance. That is, for MILP models some
nondominated points may in fact be dominated by a segment.
}
\examples{
dat <- data.frame(z1=c(12,14,16,18,18,18,14,15,15), z2=c(18,16,12,4,2,6,14,14,16))
points <- addNDSet(dat, crit = "min", keepDom = TRUE)
plotNDSet2D(points, crit = "min", addTriangles = TRUE)
plotNDSet2D(points, crit = "min", addTriangles = FALSE)
plotNDSet2D(points, crit = "min", addTriangles = TRUE, addHull = FALSE)
points <- addNDSet(dat, crit = "max", keepDom = TRUE)
plotNDSet2D(points, crit = "max", addTriangles = TRUE)
plotNDSet2D(points, crit = "max", addHull = FALSE)
}
\author{
Lars Relund \email{lars@relund.dk}
}
